/*
 * Decompiled with CFR 0.152.
 */
package com.lnicf.PortMinerPlugin;

import com.lnicf.PortMinerPlugin.CommandHandler;
import com.lnicf.PortMinerPlugin.PortManager;
import com.lnicf.PortMinerPlugin.Updater;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PortMinerPlugin
extends JavaPlugin {
    public static final double version = 1.1;
    FileConfiguration config = this.getConfig();
    int Port = 0;
    String Ip = null;
    boolean outdated = Updater.outdated();
    boolean portOpen = false;

    public void onLoad() {
        this.getConfig();
        this.config.addDefault("enabled", (Object)true);
        this.config.addDefault("allow-outdated", (Object)false);
        this.config.options().copyDefaults(true);
        this.saveConfig();
        this.Port = this.getServer().getPort();
        if (this.getServer().getIp().isEmpty()) {
            InetAddress IPa = null;
            try {
                IPa = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                this.setEnabled(false);
            }
            this.Ip = IPa.getHostAddress();
        } else {
            this.Ip = this.getServer().getIp();
        }
    }

    public void onEnable() {
        this.getCommand("pmp").setExecutor((CommandExecutor)new CommandHandler());
        if (this.config.getBoolean("enabled")) {
            this.getLogger().info("Checking for updates...");
            if (!this.outdated) {
                this.getLogger().info("No updates available.");
                this.getLogger().info("Server's Internal IP is: " + this.Ip + ":" + this.Port);
                PortManager.openPort(this.Ip, this.Port, "MCServer", "TCP");
                this.portOpen = true;
                this.getLogger().info("Opened port " + this.Port);
            } else if (this.outdated && this.config.getBoolean("allow-outdated")) {
                this.getLogger().warning("USING AN OUTDATED VERSION OF PORTMINERPLUGIN MAY CAUSE INSTABILITY.");
                this.getLogger().info("Server's Internal IP is: " + this.Ip + ":" + this.Port);
                PortManager.openPort(this.Ip, this.Port, "MCServer", "TCP");
                this.portOpen = true;
                this.getLogger().info("Opened port " + this.Port);
            } else {
                this.getLogger().warning("PortMinerPlugin is outdated and the config is set to not run an outdated verison.\nPlease update PortMinerPlugin as older versions may have issues.");
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
            }
        } else {
            this.getLogger().info("PortMinerPlugin is disabled in config. Not opening port " + this.Port);
        }
    }

    public void onDisable() {
        if (this.portOpen) {
            PortManager.closePort();
        }
    }
}

