/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.binding.xml;

import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.fourthline.cling.binding.staging.MutableDevice;
import org.fourthline.cling.binding.staging.MutableIcon;
import org.fourthline.cling.binding.staging.MutableService;
import org.fourthline.cling.binding.staging.MutableUDAVersion;
import org.fourthline.cling.binding.xml.Descriptor;
import org.fourthline.cling.binding.xml.DescriptorBindingException;
import org.fourthline.cling.binding.xml.DeviceDescriptorBinder;
import org.fourthline.cling.binding.xml.UDA10DeviceDescriptorBinderImpl;
import org.fourthline.cling.model.ValidationException;
import org.fourthline.cling.model.meta.Device;
import org.fourthline.cling.model.types.DLNACaps;
import org.fourthline.cling.model.types.DLNADoc;
import org.fourthline.cling.model.types.InvalidValueException;
import org.fourthline.cling.model.types.ServiceId;
import org.fourthline.cling.model.types.ServiceType;
import org.fourthline.cling.model.types.UDN;
import org.seamless.util.MimeType;
import org.seamless.xml.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UDA10DeviceDescriptorBinderSAXImpl
extends UDA10DeviceDescriptorBinderImpl {
    private static Logger log = Logger.getLogger(DeviceDescriptorBinder.class.getName());

    @Override
    public <D extends Device> D describe(D undescribedDevice, String descriptorXml) throws DescriptorBindingException, ValidationException {
        if (descriptorXml == null || descriptorXml.length() == 0) {
            throw new DescriptorBindingException("Null or empty descriptor");
        }
        try {
            log.fine("Populating device from XML descriptor: " + undescribedDevice);
            SAXParser parser = new SAXParser();
            MutableDevice descriptor = new MutableDevice();
            new RootHandler(descriptor, parser);
            parser.parse(new InputSource(new StringReader(descriptorXml.trim())));
            return (D)descriptor.build(undescribedDevice);
        }
        catch (ValidationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DescriptorBindingException("Could not parse device descriptor: " + ex.toString(), ex);
        }
    }

    protected static class DeviceDescriptorHandler<I>
    extends SAXParser.Handler<I> {
        public DeviceDescriptorHandler(I instance) {
            super(instance);
        }

        public DeviceDescriptorHandler(I instance, SAXParser parser) {
            super(instance, parser);
        }

        public DeviceDescriptorHandler(I instance, DeviceDescriptorHandler parent) {
            super(instance, (SAXParser.Handler)parent);
        }

        public DeviceDescriptorHandler(I instance, SAXParser parser, DeviceDescriptorHandler parent) {
            super(instance, parser, (SAXParser.Handler)parent);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            Descriptor.Device.ELEMENT el = Descriptor.Device.ELEMENT.valueOrNullOf(localName);
            if (el == null) {
                return;
            }
            this.startElement(el, attributes);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            Descriptor.Device.ELEMENT el = Descriptor.Device.ELEMENT.valueOrNullOf(localName);
            if (el == null) {
                return;
            }
            this.endElement(el);
        }

        protected boolean isLastElement(String uri, String localName, String qName) {
            Descriptor.Device.ELEMENT el = Descriptor.Device.ELEMENT.valueOrNullOf(localName);
            return el != null && this.isLastElement(el);
        }

        public void startElement(Descriptor.Device.ELEMENT element, Attributes attributes) throws SAXException {
        }

        public void endElement(Descriptor.Device.ELEMENT element) throws SAXException {
        }

        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return false;
        }
    }

    protected static class DeviceListHandler
    extends DeviceDescriptorHandler<List<MutableDevice>> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.deviceList;

        public DeviceListHandler(List<MutableDevice> instance, DeviceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void startElement(Descriptor.Device.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)DeviceHandler.EL)) {
                MutableDevice device = new MutableDevice();
                ((List)this.getInstance()).add(device);
                new DeviceHandler(device, (DeviceDescriptorHandler)this);
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class ServiceHandler
    extends DeviceDescriptorHandler<MutableService> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.service;

        public ServiceHandler(MutableService instance, DeviceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void endElement(Descriptor.Device.ELEMENT element) throws SAXException {
            try {
                switch (element) {
                    case serviceType: {
                        ((MutableService)this.getInstance()).serviceType = ServiceType.valueOf(this.getCharacters());
                        break;
                    }
                    case serviceId: {
                        ((MutableService)this.getInstance()).serviceId = ServiceId.valueOf(this.getCharacters());
                        break;
                    }
                    case SCPDURL: {
                        ((MutableService)this.getInstance()).descriptorURI = UDA10DeviceDescriptorBinderImpl.parseURI(this.getCharacters());
                        break;
                    }
                    case controlURL: {
                        ((MutableService)this.getInstance()).controlURI = UDA10DeviceDescriptorBinderImpl.parseURI(this.getCharacters());
                        break;
                    }
                    case eventSubURL: {
                        ((MutableService)this.getInstance()).eventSubscriptionURI = UDA10DeviceDescriptorBinderImpl.parseURI(this.getCharacters());
                    }
                }
            }
            catch (InvalidValueException ex) {
                log.warning("UPnP specification violation, skipping invalid service declaration. " + ex.getMessage());
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class ServiceListHandler
    extends DeviceDescriptorHandler<List<MutableService>> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.serviceList;

        public ServiceListHandler(List<MutableService> instance, DeviceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void startElement(Descriptor.Device.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)ServiceHandler.EL)) {
                MutableService service = new MutableService();
                ((List)this.getInstance()).add(service);
                new ServiceHandler(service, (DeviceDescriptorHandler)this);
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            boolean last = element.equals((Object)EL);
            if (last) {
                Iterator it = ((List)this.getInstance()).iterator();
                while (it.hasNext()) {
                    MutableService service = (MutableService)it.next();
                    if (service.serviceType != null && service.serviceId != null) continue;
                    it.remove();
                }
            }
            return last;
        }
    }

    protected static class IconHandler
    extends DeviceDescriptorHandler<MutableIcon> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.icon;

        public IconHandler(MutableIcon instance, DeviceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void endElement(Descriptor.Device.ELEMENT element) throws SAXException {
            switch (element) {
                case width: {
                    ((MutableIcon)this.getInstance()).width = Integer.valueOf(this.getCharacters());
                    break;
                }
                case height: {
                    ((MutableIcon)this.getInstance()).height = Integer.valueOf(this.getCharacters());
                    break;
                }
                case depth: {
                    try {
                        ((MutableIcon)this.getInstance()).depth = Integer.valueOf(this.getCharacters());
                    }
                    catch (NumberFormatException ex) {
                        log.warning("Invalid icon depth '" + this.getCharacters() + "', using 16 as default: " + ex);
                        ((MutableIcon)this.getInstance()).depth = 16;
                    }
                    break;
                }
                case url: {
                    ((MutableIcon)this.getInstance()).uri = UDA10DeviceDescriptorBinderImpl.parseURI(this.getCharacters());
                    break;
                }
                case mimetype: {
                    try {
                        ((MutableIcon)this.getInstance()).mimeType = this.getCharacters();
                        MimeType.valueOf(((MutableIcon)this.getInstance()).mimeType);
                        break;
                    }
                    catch (IllegalArgumentException ex) {
                        log.warning("Ignoring invalid icon mime type: " + ((MutableIcon)this.getInstance()).mimeType);
                        ((MutableIcon)this.getInstance()).mimeType = "";
                    }
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class IconListHandler
    extends DeviceDescriptorHandler<List<MutableIcon>> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.iconList;

        public IconListHandler(List<MutableIcon> instance, DeviceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void startElement(Descriptor.Device.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)IconHandler.EL)) {
                MutableIcon icon = new MutableIcon();
                ((List)this.getInstance()).add(icon);
                new IconHandler(icon, (DeviceDescriptorHandler)this);
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class DeviceHandler
    extends DeviceDescriptorHandler<MutableDevice> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.device;

        public DeviceHandler(MutableDevice instance, DeviceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void startElement(Descriptor.Device.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)IconListHandler.EL)) {
                ArrayList<MutableIcon> icons = new ArrayList<MutableIcon>();
                ((MutableDevice)this.getInstance()).icons = icons;
                new IconListHandler((List<MutableIcon>)icons, (DeviceDescriptorHandler)this);
            }
            if (element.equals((Object)ServiceListHandler.EL)) {
                ArrayList<MutableService> services = new ArrayList<MutableService>();
                ((MutableDevice)this.getInstance()).services = services;
                new ServiceListHandler((List<MutableService>)services, (DeviceDescriptorHandler)this);
            }
            if (element.equals((Object)DeviceListHandler.EL)) {
                ArrayList<MutableDevice> devices = new ArrayList<MutableDevice>();
                ((MutableDevice)this.getInstance()).embeddedDevices = devices;
                new DeviceListHandler((List<MutableDevice>)devices, (DeviceDescriptorHandler)this);
            }
        }

        @Override
        public void endElement(Descriptor.Device.ELEMENT element) throws SAXException {
            switch (element) {
                case deviceType: {
                    ((MutableDevice)this.getInstance()).deviceType = this.getCharacters();
                    break;
                }
                case friendlyName: {
                    ((MutableDevice)this.getInstance()).friendlyName = this.getCharacters();
                    break;
                }
                case manufacturer: {
                    ((MutableDevice)this.getInstance()).manufacturer = this.getCharacters();
                    break;
                }
                case manufacturerURL: {
                    ((MutableDevice)this.getInstance()).manufacturerURI = UDA10DeviceDescriptorBinderImpl.parseURI(this.getCharacters());
                    break;
                }
                case modelDescription: {
                    ((MutableDevice)this.getInstance()).modelDescription = this.getCharacters();
                    break;
                }
                case modelName: {
                    ((MutableDevice)this.getInstance()).modelName = this.getCharacters();
                    break;
                }
                case modelNumber: {
                    ((MutableDevice)this.getInstance()).modelNumber = this.getCharacters();
                    break;
                }
                case modelURL: {
                    ((MutableDevice)this.getInstance()).modelURI = UDA10DeviceDescriptorBinderImpl.parseURI(this.getCharacters());
                    break;
                }
                case presentationURL: {
                    ((MutableDevice)this.getInstance()).presentationURI = UDA10DeviceDescriptorBinderImpl.parseURI(this.getCharacters());
                    break;
                }
                case UPC: {
                    ((MutableDevice)this.getInstance()).upc = this.getCharacters();
                    break;
                }
                case serialNumber: {
                    ((MutableDevice)this.getInstance()).serialNumber = this.getCharacters();
                    break;
                }
                case UDN: {
                    ((MutableDevice)this.getInstance()).udn = UDN.valueOf(this.getCharacters());
                    break;
                }
                case X_DLNADOC: {
                    String txt = this.getCharacters();
                    try {
                        ((MutableDevice)this.getInstance()).dlnaDocs.add(DLNADoc.valueOf(txt));
                    }
                    catch (InvalidValueException ex) {
                        log.info("Invalid X_DLNADOC value, ignoring value: " + txt);
                    }
                    break;
                }
                case X_DLNACAP: {
                    ((MutableDevice)this.getInstance()).dlnaCaps = DLNACaps.valueOf(this.getCharacters());
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class SpecVersionHandler
    extends DeviceDescriptorHandler<MutableUDAVersion> {
        public static final Descriptor.Device.ELEMENT EL = Descriptor.Device.ELEMENT.specVersion;

        public SpecVersionHandler(MutableUDAVersion instance, DeviceDescriptorHandler parent) {
            super(instance, parent);
        }

        @Override
        public void endElement(Descriptor.Device.ELEMENT element) throws SAXException {
            switch (element) {
                case major: {
                    String majorVersion = this.getCharacters().trim();
                    if (!majorVersion.equals("1")) {
                        log.warning("Unsupported UDA major version, ignoring: " + majorVersion);
                        majorVersion = "1";
                    }
                    ((MutableUDAVersion)this.getInstance()).major = Integer.valueOf(majorVersion);
                    break;
                }
                case minor: {
                    String minorVersion = this.getCharacters().trim();
                    if (!minorVersion.equals("0")) {
                        log.warning("Unsupported UDA minor version, ignoring: " + minorVersion);
                        minorVersion = "0";
                    }
                    ((MutableUDAVersion)this.getInstance()).minor = Integer.valueOf(minorVersion);
                }
            }
        }

        @Override
        public boolean isLastElement(Descriptor.Device.ELEMENT element) {
            return element.equals((Object)EL);
        }
    }

    protected static class RootHandler
    extends DeviceDescriptorHandler<MutableDevice> {
        public RootHandler(MutableDevice instance, SAXParser parser) {
            super(instance, parser);
        }

        @Override
        public void startElement(Descriptor.Device.ELEMENT element, Attributes attributes) throws SAXException {
            if (element.equals((Object)SpecVersionHandler.EL)) {
                MutableUDAVersion udaVersion;
                ((MutableDevice)this.getInstance()).udaVersion = udaVersion = new MutableUDAVersion();
                new SpecVersionHandler(udaVersion, (DeviceDescriptorHandler)this);
            }
            if (element.equals((Object)DeviceHandler.EL)) {
                new DeviceHandler((MutableDevice)this.getInstance(), (DeviceDescriptorHandler)this);
            }
        }

        @Override
        public void endElement(Descriptor.Device.ELEMENT element) throws SAXException {
            switch (element) {
                case URLBase: {
                    try {
                        String urlString = this.getCharacters();
                        if (urlString == null || urlString.length() <= 0) break;
                        ((MutableDevice)this.getInstance()).baseURL = new URL(urlString);
                        break;
                    }
                    catch (Exception ex) {
                        throw new SAXException("Invalid URLBase: " + ex.toString());
                    }
                }
            }
        }
    }
}

