/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.connectionmanager;

import java.beans.PropertyChangeSupport;
import java.util.logging.Logger;
import org.fourthline.cling.binding.annotations.UpnpAction;
import org.fourthline.cling.binding.annotations.UpnpInputArgument;
import org.fourthline.cling.binding.annotations.UpnpOutputArgument;
import org.fourthline.cling.controlpoint.ControlPoint;
import org.fourthline.cling.model.ServiceReference;
import org.fourthline.cling.model.action.ActionException;
import org.fourthline.cling.model.action.ActionInvocation;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.model.types.ErrorCode;
import org.fourthline.cling.model.types.UnsignedIntegerFourBytes;
import org.fourthline.cling.model.types.csv.CSV;
import org.fourthline.cling.support.connectionmanager.ConnectionManagerException;
import org.fourthline.cling.support.connectionmanager.ConnectionManagerService;
import org.fourthline.cling.support.connectionmanager.callback.ConnectionComplete;
import org.fourthline.cling.support.connectionmanager.callback.PrepareForConnection;
import org.fourthline.cling.support.model.ConnectionInfo;
import org.fourthline.cling.support.model.ProtocolInfo;
import org.fourthline.cling.support.model.ProtocolInfos;

public abstract class AbstractPeeringConnectionManagerService
extends ConnectionManagerService {
    private static final Logger log = Logger.getLogger(AbstractPeeringConnectionManagerService.class.getName());

    protected AbstractPeeringConnectionManagerService(ConnectionInfo ... activeConnections) {
        super(activeConnections);
    }

    protected AbstractPeeringConnectionManagerService(ProtocolInfos sourceProtocolInfo, ProtocolInfos sinkProtocolInfo, ConnectionInfo ... activeConnections) {
        super(sourceProtocolInfo, sinkProtocolInfo, activeConnections);
    }

    protected AbstractPeeringConnectionManagerService(PropertyChangeSupport propertyChangeSupport, ProtocolInfos sourceProtocolInfo, ProtocolInfos sinkProtocolInfo, ConnectionInfo ... activeConnections) {
        super(propertyChangeSupport, sourceProtocolInfo, sinkProtocolInfo, activeConnections);
    }

    protected synchronized int getNewConnectionId() {
        int currentHighestID = -1;
        for (Integer key : this.activeConnections.keySet()) {
            if (key <= currentHighestID) continue;
            currentHighestID = key;
        }
        return ++currentHighestID;
    }

    protected synchronized void storeConnection(ConnectionInfo info) {
        CSV<UnsignedIntegerFourBytes> oldConnectionIDs = this.getCurrentConnectionIDs();
        this.activeConnections.put(info.getConnectionID(), info);
        log.fine("Connection stored, firing event: " + info.getConnectionID());
        CSV<UnsignedIntegerFourBytes> newConnectionIDs = this.getCurrentConnectionIDs();
        this.getPropertyChangeSupport().firePropertyChange("CurrentConnectionIDs", oldConnectionIDs, newConnectionIDs);
    }

    protected synchronized void removeConnection(int connectionID) {
        CSV<UnsignedIntegerFourBytes> oldConnectionIDs = this.getCurrentConnectionIDs();
        this.activeConnections.remove(connectionID);
        log.fine("Connection removed, firing event: " + connectionID);
        CSV<UnsignedIntegerFourBytes> newConnectionIDs = this.getCurrentConnectionIDs();
        this.getPropertyChangeSupport().firePropertyChange("CurrentConnectionIDs", oldConnectionIDs, newConnectionIDs);
    }

    @UpnpAction(out={@UpnpOutputArgument(name="ConnectionID", stateVariable="A_ARG_TYPE_ConnectionID", getterName="getConnectionID"), @UpnpOutputArgument(name="AVTransportID", stateVariable="A_ARG_TYPE_AVTransportID", getterName="getAvTransportID"), @UpnpOutputArgument(name="RcsID", stateVariable="A_ARG_TYPE_RcsID", getterName="getRcsID")})
    public synchronized ConnectionInfo prepareForConnection(@UpnpInputArgument(name="RemoteProtocolInfo", stateVariable="A_ARG_TYPE_ProtocolInfo") ProtocolInfo remoteProtocolInfo, @UpnpInputArgument(name="PeerConnectionManager", stateVariable="A_ARG_TYPE_ConnectionManager") ServiceReference peerConnectionManager, @UpnpInputArgument(name="PeerConnectionID", stateVariable="A_ARG_TYPE_ConnectionID") int peerConnectionId, @UpnpInputArgument(name="Direction", stateVariable="A_ARG_TYPE_Direction") String direction) throws ActionException {
        ConnectionInfo.Direction dir;
        int connectionId = this.getNewConnectionId();
        try {
            dir = ConnectionInfo.Direction.valueOf(direction);
        }
        catch (Exception ex) {
            throw new ConnectionManagerException(ErrorCode.ARGUMENT_VALUE_INVALID, "Unsupported direction: " + direction);
        }
        log.fine("Preparing for connection with local new ID " + connectionId + " and peer connection ID: " + peerConnectionId);
        ConnectionInfo newConnectionInfo = this.createConnection(connectionId, peerConnectionId, peerConnectionManager, dir, remoteProtocolInfo);
        this.storeConnection(newConnectionInfo);
        return newConnectionInfo;
    }

    @UpnpAction
    public synchronized void connectionComplete(@UpnpInputArgument(name="ConnectionID", stateVariable="A_ARG_TYPE_ConnectionID") int connectionID) throws ActionException {
        ConnectionInfo info = this.getCurrentConnectionInfo(connectionID);
        log.fine("Closing connection ID " + connectionID);
        this.closeConnection(info);
        this.removeConnection(connectionID);
    }

    public synchronized int createConnectionWithPeer(ServiceReference localServiceReference, ControlPoint controlPoint, final Service peerService, final ProtocolInfo protInfo, final ConnectionInfo.Direction direction) {
        final int localConnectionID = this.getNewConnectionId();
        log.fine("Creating new connection ID " + localConnectionID + " with peer: " + peerService);
        final boolean[] failed = new boolean[1];
        new PrepareForConnection(peerService, controlPoint, protInfo, localServiceReference, localConnectionID, direction){

            @Override
            public void received(ActionInvocation invocation, int peerConnectionID, int rcsID, int avTransportID) {
                ConnectionInfo info = new ConnectionInfo(localConnectionID, rcsID, avTransportID, protInfo, peerService.getReference(), peerConnectionID, direction.getOpposite(), ConnectionInfo.Status.OK);
                AbstractPeeringConnectionManagerService.this.storeConnection(info);
            }

            @Override
            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                AbstractPeeringConnectionManagerService.this.peerFailure(invocation, operation, defaultMsg);
                failed[0] = true;
            }
        }.run();
        return failed[0] ? -1 : localConnectionID;
    }

    public synchronized void closeConnectionWithPeer(ControlPoint controlPoint, Service peerService, int connectionID) throws ActionException {
        this.closeConnectionWithPeer(controlPoint, peerService, this.getCurrentConnectionInfo(connectionID));
    }

    public synchronized void closeConnectionWithPeer(ControlPoint controlPoint, Service peerService, final ConnectionInfo connectionInfo) throws ActionException {
        log.fine("Closing connection ID " + connectionInfo.getConnectionID() + " with peer: " + peerService);
        new ConnectionComplete(peerService, controlPoint, connectionInfo.getPeerConnectionID()){

            @Override
            public void success(ActionInvocation invocation) {
                AbstractPeeringConnectionManagerService.this.removeConnection(connectionInfo.getConnectionID());
            }

            @Override
            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                AbstractPeeringConnectionManagerService.this.peerFailure(invocation, operation, defaultMsg);
            }
        }.run();
    }

    protected abstract ConnectionInfo createConnection(int var1, int var2, ServiceReference var3, ConnectionInfo.Direction var4, ProtocolInfo var5) throws ActionException;

    protected abstract void closeConnection(ConnectionInfo var1);

    protected abstract void peerFailure(ActionInvocation var1, UpnpResponse var2, String var3);
}

