/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.contentdirectory.callback;

import java.util.logging.Logger;
import org.fourthline.cling.controlpoint.ActionCallback;
import org.fourthline.cling.model.action.ActionException;
import org.fourthline.cling.model.action.ActionInvocation;
import org.fourthline.cling.model.meta.Service;
import org.fourthline.cling.model.types.ErrorCode;
import org.fourthline.cling.model.types.UnsignedIntegerFourBytes;
import org.fourthline.cling.support.contentdirectory.DIDLParser;
import org.fourthline.cling.support.model.BrowseFlag;
import org.fourthline.cling.support.model.BrowseResult;
import org.fourthline.cling.support.model.DIDLContent;
import org.fourthline.cling.support.model.SortCriterion;

public abstract class Browse
extends ActionCallback {
    public static final String CAPS_WILDCARD = "*";
    private static Logger log = Logger.getLogger(Browse.class.getName());

    public Browse(Service service, String containerId, BrowseFlag flag) {
        this(service, containerId, flag, CAPS_WILDCARD, 0L, null, new SortCriterion[0]);
    }

    public Browse(Service service, String objectID, BrowseFlag flag, String filter, long firstResult, Long maxResults, SortCriterion ... orderBy) {
        super(new ActionInvocation(service.getAction("Browse")));
        log.fine("Creating browse action for object ID: " + objectID);
        this.getActionInvocation().setInput("ObjectID", objectID);
        this.getActionInvocation().setInput("BrowseFlag", flag.toString());
        this.getActionInvocation().setInput("Filter", filter);
        this.getActionInvocation().setInput("StartingIndex", new UnsignedIntegerFourBytes(firstResult));
        this.getActionInvocation().setInput("RequestedCount", new UnsignedIntegerFourBytes(maxResults == null ? this.getDefaultMaxResults() : maxResults.longValue()));
        this.getActionInvocation().setInput("SortCriteria", SortCriterion.toString(orderBy));
    }

    @Override
    public void run() {
        this.updateStatus(Status.LOADING);
        super.run();
    }

    @Override
    public void success(ActionInvocation invocation) {
        log.fine("Successful browse action, reading output argument values");
        BrowseResult result = new BrowseResult(invocation.getOutput("Result").getValue().toString(), (UnsignedIntegerFourBytes)invocation.getOutput("NumberReturned").getValue(), (UnsignedIntegerFourBytes)invocation.getOutput("TotalMatches").getValue(), (UnsignedIntegerFourBytes)invocation.getOutput("UpdateID").getValue());
        boolean proceed = this.receivedRaw(invocation, result);
        if (proceed && result.getCountLong() > 0L && result.getResult().length() > 0) {
            try {
                DIDLParser didlParser = new DIDLParser();
                DIDLContent didl = didlParser.parse(result.getResult());
                this.received(invocation, didl);
                this.updateStatus(Status.OK);
            }
            catch (Exception ex) {
                invocation.setFailure(new ActionException(ErrorCode.ACTION_FAILED, "Can't parse DIDL XML response: " + ex, (Throwable)ex));
                this.failure(invocation, null);
            }
        } else {
            this.received(invocation, new DIDLContent());
            this.updateStatus(Status.NO_CONTENT);
        }
    }

    public long getDefaultMaxResults() {
        return 999L;
    }

    public boolean receivedRaw(ActionInvocation actionInvocation, BrowseResult browseResult) {
        return true;
    }

    public abstract void received(ActionInvocation var1, DIDLContent var2);

    public abstract void updateStatus(Status var1);

    public static enum Status {
        NO_CONTENT("No Content"),
        LOADING("Loading..."),
        OK("OK");

        private String defaultMessage;

        private Status(String defaultMessage) {
            this.defaultMessage = defaultMessage;
        }

        public String getDefaultMessage() {
            return this.defaultMessage;
        }
    }
}

