/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.lastchange;

import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.fourthline.cling.model.XMLUtil;
import org.fourthline.cling.model.types.UnsignedIntegerFourBytes;
import org.fourthline.cling.support.lastchange.Event;
import org.fourthline.cling.support.lastchange.EventedValue;
import org.fourthline.cling.support.lastchange.InstanceID;
import org.fourthline.cling.support.shared.AbstractMap;
import org.seamless.util.Exceptions;
import org.seamless.util.io.IO;
import org.seamless.xml.DOMParser;
import org.seamless.xml.SAXParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class LastChangeParser
extends SAXParser {
    private static final Logger log = Logger.getLogger(LastChangeParser.class.getName());

    protected abstract String getNamespace();

    protected Set<Class<? extends EventedValue>> getEventedVariables() {
        return Collections.EMPTY_SET;
    }

    protected EventedValue createValue(String name, Map.Entry<String, String>[] attributes) throws Exception {
        for (Class<? extends EventedValue> evType : this.getEventedVariables()) {
            if (!evType.getSimpleName().equals(name)) continue;
            Constructor<? extends EventedValue> ctor = evType.getConstructor(Map.Entry[].class);
            return ctor.newInstance(new Object[]{attributes});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Event parseResource(String resource) throws Exception {
        try (InputStream is = null;){
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
            Event event = this.parse(IO.readLines(is));
            return event;
        }
    }

    public Event parse(String xml) throws Exception {
        if (xml == null || xml.length() == 0) {
            throw new RuntimeException("Null or empty XML");
        }
        Event event = new Event();
        new RootHandler(event, this);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Parsing 'LastChange' event XML content");
            log.fine("===================================== 'LastChange' BEGIN ============================================");
            log.fine(xml);
            log.fine("====================================== 'LastChange' END  ============================================");
        }
        this.parse(new InputSource(new StringReader(xml)));
        log.fine("Parsed event with instances IDs: " + event.getInstanceIDs().size());
        if (log.isLoggable(Level.FINEST)) {
            for (InstanceID instanceID : event.getInstanceIDs()) {
                log.finest("InstanceID '" + instanceID.getId() + "' has values: " + instanceID.getValues().size());
                for (EventedValue eventedValue : instanceID.getValues()) {
                    log.finest(eventedValue.getName() + " => " + eventedValue.getValue());
                }
            }
        }
        return event;
    }

    public String generate(Event event) throws Exception {
        return XMLUtil.documentToFragmentString(this.buildDOM(event));
    }

    protected Document buildDOM(Event event) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document d = factory.newDocumentBuilder().newDocument();
        this.generateRoot(event, d);
        return d;
    }

    protected void generateRoot(Event event, Document descriptor) {
        Element eventElement = descriptor.createElementNS(this.getNamespace(), CONSTANTS.Event.name());
        descriptor.appendChild(eventElement);
        this.generateInstanceIDs(event, descriptor, eventElement);
    }

    protected void generateInstanceIDs(Event event, Document descriptor, Element rootElement) {
        for (InstanceID instanceID : event.getInstanceIDs()) {
            if (instanceID.getId() == null) continue;
            Element instanceIDElement = XMLUtil.appendNewElement(descriptor, rootElement, CONSTANTS.InstanceID.name());
            instanceIDElement.setAttribute(CONSTANTS.val.name(), instanceID.getId().toString());
            for (EventedValue eventedValue : instanceID.getValues()) {
                this.generateEventedValue(eventedValue, descriptor, instanceIDElement);
            }
        }
    }

    protected void generateEventedValue(EventedValue eventedValue, Document descriptor, Element parentElement) {
        String name = eventedValue.getName();
        Map.Entry<String, String>[] attributes = eventedValue.getAttributes();
        if (attributes != null && attributes.length > 0) {
            Element evElement = XMLUtil.appendNewElement(descriptor, parentElement, name);
            for (Map.Entry<String, String> attr : attributes) {
                evElement.setAttribute(attr.getKey(), DOMParser.escape((String)attr.getValue()));
            }
        }
    }

    class InstanceIDHandler
    extends SAXParser.Handler<InstanceID> {
        InstanceIDHandler(InstanceID instance, SAXParser.Handler parent) {
            super((Object)instance, parent);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            Map.Entry[] attributeMap = new Map.Entry[attributes.getLength()];
            for (int i = 0; i < attributeMap.length; ++i) {
                attributeMap[i] = new AbstractMap.SimpleEntry<String, String>(attributes.getLocalName(i), attributes.getValue(i));
            }
            try {
                EventedValue esv = LastChangeParser.this.createValue(localName, attributeMap);
                if (esv != null) {
                    ((InstanceID)this.getInstance()).getValues().add(esv);
                }
            }
            catch (Exception ex) {
                log.warning("Error reading event XML, ignoring value: " + Exceptions.unwrap(ex));
            }
        }

        protected boolean isLastElement(String uri, String localName, String qName) {
            return CONSTANTS.InstanceID.equals(localName);
        }
    }

    class RootHandler
    extends SAXParser.Handler<Event> {
        RootHandler(Event instance, SAXParser parser) {
            super((Object)instance, parser);
        }

        RootHandler(Event instance) {
            super((Object)instance);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String valAttr;
            super.startElement(uri, localName, qName, attributes);
            if (CONSTANTS.InstanceID.equals(localName) && (valAttr = attributes.getValue(CONSTANTS.val.name())) != null) {
                InstanceID instanceID = new InstanceID(new UnsignedIntegerFourBytes(valAttr));
                ((Event)this.getInstance()).getInstanceIDs().add(instanceID);
                new InstanceIDHandler(instanceID, this);
            }
        }
    }

    public static enum CONSTANTS {
        Event,
        InstanceID,
        val;


        public boolean equals(String s) {
            return this.name().equals(s);
        }
    }
}

