/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.dlna.message.header;

import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.support.model.dlna.message.header.DLNAHeader;
import org.fourthline.cling.support.model.dlna.types.NormalPlayTime;

public class RealTimeInfoHeader
extends DLNAHeader<NormalPlayTime> {
    public static final String PREFIX = "DLNA.ORG_TLAG=";

    @Override
    public void setString(String s) throws InvalidHeaderException {
        if (s.length() != 0 && s.startsWith(PREFIX)) {
            try {
                s = s.substring(PREFIX.length());
                this.setValue(s.equals("*") ? null : NormalPlayTime.valueOf(s));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new InvalidHeaderException("Invalid RealTimeInfo header value: " + s);
    }

    @Override
    public String getString() {
        NormalPlayTime v = (NormalPlayTime)this.getValue();
        if (v == null) {
            return "DLNA.ORG_TLAG=*";
        }
        return PREFIX + v.getString();
    }
}

