/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.shared;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.fourthline.cling.support.shared.NewPlatformApple;
import org.fourthline.cling.support.shared.ShutdownHandler;
import org.fourthline.cling.support.shared.log.LogView;
import org.seamless.swing.Application;
import org.seamless.swing.logging.LogMessage;
import org.seamless.swing.logging.LoggingHandler;
import org.seamless.util.OS;
import org.seamless.util.logging.LoggingUtil;

public abstract class Main
implements ShutdownHandler,
Thread.UncaughtExceptionHandler {
    @Inject
    LogView.Presenter logPresenter;
    protected final JFrame errorWindow = new JFrame();
    protected final LoggingHandler loggingHandler = new LoggingHandler(){

        protected void log(LogMessage msg) {
            Main.this.logPresenter.pushMessage(msg);
        }
    };
    protected boolean isRegularShutdown;

    public void init() {
        try {
            if (OS.checkForMac()) {
                NewPlatformApple.setup(this, this.getAppName());
            }
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.errorWindow.setPreferredSize(new Dimension(900, 400));
        this.errorWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Main.this.errorWindow.dispose();
            }
        });
        Thread.setDefaultUncaughtExceptionHandler(this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (!Main.this.isRegularShutdown) {
                    Main.this.shutdown();
                }
            }
        });
        if (System.getProperty("java.util.logging.config.file") == null) {
            LoggingUtil.resetRootHandler(new Handler[]{this.loggingHandler});
        } else {
            LogManager.getLogManager().getLogger("").addHandler((Handler)this.loggingHandler);
        }
    }

    @Override
    public void shutdown() {
        this.isRegularShutdown = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.errorWindow.dispose();
            }
        });
    }

    @Override
    public void uncaughtException(Thread thread, final Throwable throwable) {
        System.err.println("In thread '" + thread + "' uncaught exception: " + throwable);
        throwable.printStackTrace(System.err);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Main.this.errorWindow.getContentPane().removeAll();
                JTextArea textArea = new JTextArea();
                textArea.setEditable(false);
                StringBuilder text = new StringBuilder();
                text.append("An exceptional error occurred!\nYou can try to continue or exit the application.\n\n");
                text.append("Please tell us about this here:\nhttp://www.4thline.org/projects/mailinglists-cling.html\n\n");
                text.append("-------------------------------------------------------------------------------------------------------------\n\n");
                StringWriter stackTrace = new StringWriter();
                throwable.printStackTrace(new PrintWriter(stackTrace));
                text.append(((Object)stackTrace).toString());
                textArea.setText(text.toString());
                JScrollPane pane = new JScrollPane(textArea);
                Main.this.errorWindow.getContentPane().add((Component)pane, "Center");
                JButton exitButton = new JButton("Exit Application");
                exitButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.exit(1);
                    }
                });
                Main.this.errorWindow.getContentPane().add((Component)exitButton, "South");
                Main.this.errorWindow.pack();
                Application.center((Window)Main.this.errorWindow);
                textArea.setCaretPosition(0);
                Main.this.errorWindow.setVisible(true);
            }
        });
    }

    protected void removeLoggingHandler() {
        LogManager.getLogManager().getLogger("").removeHandler((Handler)this.loggingHandler);
    }

    protected abstract String getAppName();
}

