/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.transport.impl.jetty;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.client.ContentExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.fourthline.cling.model.message.StreamRequestMessage;
import org.fourthline.cling.model.message.StreamResponseMessage;
import org.fourthline.cling.model.message.UpnpHeaders;
import org.fourthline.cling.model.message.UpnpMessage;
import org.fourthline.cling.model.message.UpnpRequest;
import org.fourthline.cling.model.message.UpnpResponse;
import org.fourthline.cling.model.message.header.ContentTypeHeader;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.transport.impl.jetty.StreamClientConfigurationImpl;
import org.fourthline.cling.transport.spi.AbstractStreamClient;
import org.fourthline.cling.transport.spi.InitializationException;
import org.fourthline.cling.transport.spi.StreamClient;
import org.seamless.util.Exceptions;
import org.seamless.util.MimeType;

public class StreamClientImpl
extends AbstractStreamClient<StreamClientConfigurationImpl, HttpContentExchange> {
    private static final Logger log = Logger.getLogger(StreamClient.class.getName());
    protected final StreamClientConfigurationImpl configuration;
    protected final HttpClient client;

    public StreamClientImpl(StreamClientConfigurationImpl configuration) throws InitializationException {
        this.configuration = configuration;
        log.info("Starting Jetty HttpClient...");
        this.client = new HttpClient();
        this.client.setThreadPool((ThreadPool)new ExecutorThreadPool(this.getConfiguration().getRequestExecutorService()){

            protected void doStop() throws Exception {
            }
        });
        this.client.setTimeout((long)((configuration.getTimeoutSeconds() + 5) * 1000));
        this.client.setConnectTimeout((configuration.getTimeoutSeconds() + 5) * 1000);
        this.client.setMaxRetries(configuration.getRequestRetryCount());
        try {
            this.client.start();
        }
        catch (Exception ex) {
            throw new InitializationException("Could not start Jetty HTTP client: " + ex, ex);
        }
    }

    @Override
    public StreamClientConfigurationImpl getConfiguration() {
        return this.configuration;
    }

    @Override
    protected HttpContentExchange createRequest(StreamRequestMessage requestMessage) {
        return new HttpContentExchange(this.getConfiguration(), this.client, requestMessage);
    }

    @Override
    protected Callable<StreamResponseMessage> createCallable(final StreamRequestMessage requestMessage, final HttpContentExchange exchange) {
        return new Callable<StreamResponseMessage>(){

            @Override
            public StreamResponseMessage call() throws Exception {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Sending HTTP request: " + requestMessage);
                }
                StreamClientImpl.this.client.send((HttpExchange)exchange);
                int exchangeState = exchange.waitForDone();
                if (exchangeState == 7) {
                    try {
                        return exchange.createResponse();
                    }
                    catch (Throwable t) {
                        log.log(Level.WARNING, "Error reading response: " + requestMessage, Exceptions.unwrap(t));
                        return null;
                    }
                }
                if (exchangeState == 11) {
                    return null;
                }
                if (exchangeState == 9) {
                    return null;
                }
                log.warning("Unhandled HTTP exchange status: " + exchangeState);
                return null;
            }
        };
    }

    @Override
    protected void abort(HttpContentExchange exchange) {
        exchange.cancel();
    }

    @Override
    protected boolean logExecutionException(Throwable t) {
        return false;
    }

    @Override
    public void stop() {
        try {
            this.client.stop();
        }
        catch (Exception ex) {
            log.info("Error stopping HTTP client: " + ex);
        }
    }

    public static class HttpContentExchange
    extends ContentExchange {
        protected final StreamClientConfigurationImpl configuration;
        protected final HttpClient client;
        protected final StreamRequestMessage requestMessage;
        protected Throwable exception;

        public HttpContentExchange(StreamClientConfigurationImpl configuration, HttpClient client, StreamRequestMessage requestMessage) {
            super(true);
            this.configuration = configuration;
            this.client = client;
            this.requestMessage = requestMessage;
            this.applyRequestURLMethod();
            this.applyRequestHeaders();
            this.applyRequestBody();
        }

        protected void onConnectionFailed(Throwable t) {
            log.log(Level.WARNING, "HTTP connection failed: " + this.requestMessage, Exceptions.unwrap(t));
        }

        protected void onException(Throwable t) {
            log.log(Level.WARNING, "HTTP request failed: " + this.requestMessage, Exceptions.unwrap(t));
        }

        public StreamClientConfigurationImpl getConfiguration() {
            return this.configuration;
        }

        public StreamRequestMessage getRequestMessage() {
            return this.requestMessage;
        }

        protected void applyRequestURLMethod() {
            UpnpRequest requestOperation = (UpnpRequest)this.getRequestMessage().getOperation();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Preparing HTTP request message with method '" + requestOperation.getHttpMethodName() + "': " + this.getRequestMessage());
            }
            this.setURL(requestOperation.getURI().toString());
            this.setMethod(requestOperation.getHttpMethodName());
        }

        protected void applyRequestHeaders() {
            UpnpHeaders headers = this.getRequestMessage().getHeaders();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Writing headers on HttpContentExchange: " + headers.size());
            }
            if (!headers.containsKey(UpnpHeader.Type.USER_AGENT)) {
                this.setRequestHeader(UpnpHeader.Type.USER_AGENT.getHttpName(), this.getConfiguration().getUserAgentValue(this.getRequestMessage().getUdaMajorVersion(), this.getRequestMessage().getUdaMinorVersion()));
            }
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                for (String v : entry.getValue()) {
                    String headerName = entry.getKey();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Setting header '" + headerName + "': " + v);
                    }
                    this.addRequestHeader(headerName, v);
                }
            }
        }

        protected void applyRequestBody() {
            if (this.getRequestMessage().hasBody()) {
                if (this.getRequestMessage().getBodyType() == UpnpMessage.BodyType.STRING) {
                    ByteArrayBuffer buffer;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Writing textual request body: " + this.getRequestMessage());
                    }
                    MimeType contentType = this.getRequestMessage().getContentTypeHeader() != null ? (MimeType)this.getRequestMessage().getContentTypeHeader().getValue() : ContentTypeHeader.DEFAULT_CONTENT_TYPE_UTF8;
                    String charset = this.getRequestMessage().getContentTypeCharset() != null ? this.getRequestMessage().getContentTypeCharset() : "UTF-8";
                    this.setRequestContentType(contentType.toString());
                    try {
                        buffer = new ByteArrayBuffer(this.getRequestMessage().getBodyString(), charset);
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new RuntimeException("Unsupported character encoding: " + charset, ex);
                    }
                    this.setRequestHeader("Content-Length", String.valueOf(buffer.length()));
                    this.setRequestContent((Buffer)buffer);
                } else {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Writing binary request body: " + this.getRequestMessage());
                    }
                    if (this.getRequestMessage().getContentTypeHeader() == null) {
                        throw new RuntimeException("Missing content type header in request message: " + this.requestMessage);
                    }
                    MimeType contentType = (MimeType)this.getRequestMessage().getContentTypeHeader().getValue();
                    this.setRequestContentType(contentType.toString());
                    ByteArrayBuffer buffer = new ByteArrayBuffer(this.getRequestMessage().getBodyBytes());
                    this.setRequestHeader("Content-Length", String.valueOf(buffer.length()));
                    this.setRequestContent((Buffer)buffer);
                }
            }
        }

        protected StreamResponseMessage createResponse() {
            UpnpResponse responseOperation = new UpnpResponse(this.getResponseStatus(), UpnpResponse.Status.getByStatusCode(this.getResponseStatus()).getStatusMsg());
            if (log.isLoggable(Level.FINE)) {
                log.fine("Received response: " + responseOperation);
            }
            StreamResponseMessage responseMessage = new StreamResponseMessage(responseOperation);
            UpnpHeaders headers = new UpnpHeaders();
            HttpFields responseFields = this.getResponseFields();
            for (String name : responseFields.getFieldNamesCollection()) {
                for (String value : responseFields.getValuesCollection(name)) {
                    headers.add(name, value);
                }
            }
            responseMessage.setHeaders(headers);
            byte[] bytes = this.getResponseContentBytes();
            if (bytes != null && bytes.length > 0 && responseMessage.isContentTypeMissingOrText()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Response contains textual entity body, converting then setting string on message");
                }
                try {
                    responseMessage.setBodyCharacters(bytes);
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException("Unsupported character encoding: " + ex, ex);
                }
            } else if (bytes != null && bytes.length > 0) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Response contains binary entity body, setting bytes on message");
                }
                responseMessage.setBody(UpnpMessage.BodyType.BYTES, bytes);
            } else if (log.isLoggable(Level.FINE)) {
                log.fine("Response did not contain entity body");
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Response message complete: " + responseMessage);
            }
            return responseMessage;
        }
    }
}

